/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.motor;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.compat.computercraft.ComputerCraftProxy;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.motor.CreativeMotorBlock;
import com.simibubi.create.content.kinetics.motor.KineticScrollValueBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.List;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4587;

public class CreativeMotorBlockEntity
extends GeneratingKineticBlockEntity {
    public static final int DEFAULT_SPEED = 16;
    public static final int MAX_SPEED = 256;
    public ScrollValueBehaviour generatedSpeed;
    public AbstractComputerBehaviour computerBehaviour;

    public CreativeMotorBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        int max = 256;
        this.generatedSpeed = new KineticScrollValueBehaviour((class_2561)CreateLang.translateDirect("kinetics.creative_motor.rotation_speed", new Object[0]), this, new MotorValueBox());
        this.generatedSpeed.between(-max, max);
        this.generatedSpeed.value = 16;
        this.generatedSpeed.withCallback(i -> this.updateGeneratedRotation());
        behaviours.add(this.generatedSpeed);
        this.computerBehaviour = ComputerCraftProxy.behaviour(this);
        behaviours.add(this.computerBehaviour);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.hasSource() || this.getGeneratedSpeed() > this.getTheoreticalSpeed()) {
            this.updateGeneratedRotation();
        }
    }

    @Override
    public float getGeneratedSpeed() {
        if (!AllBlocks.CREATIVE_MOTOR.has(this.method_11010())) {
            return 0.0f;
        }
        return CreativeMotorBlockEntity.convertToDirection(this.generatedSpeed.getValue(), (class_2350)this.method_11010().method_11654((class_2769)CreativeMotorBlock.FACING));
    }

    class MotorValueBox
    extends ValueBoxTransform.Sided {
        MotorValueBox() {
        }

        @Override
        protected class_243 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)12.5);
        }

        @Override
        public class_243 getLocalOffset(class_1936 level, class_2338 pos, class_2680 state) {
            class_2350 facing = (class_2350)state.method_11654((class_2769)CreativeMotorBlock.FACING);
            return super.getLocalOffset(level, pos, state).method_1019(class_243.method_24954((class_2382)facing.method_10163()).method_1021(-0.0625));
        }

        @Override
        public void rotate(class_1936 level, class_2338 pos, class_2680 state, class_4587 ms) {
            super.rotate(level, pos, state, ms);
            class_2350 facing = (class_2350)state.method_11654((class_2769)CreativeMotorBlock.FACING);
            if (facing.method_10166() == class_2350.class_2351.field_11052) {
                return;
            }
            if (this.getSide() != class_2350.field_11036) {
                return;
            }
            TransformStack.of((class_4587)ms).rotateZDegrees(-AngleHelper.horizontalAngle((class_2350)facing) + 180.0f);
        }

        @Override
        protected boolean isSideActive(class_2680 state, class_2350 direction) {
            class_2350 facing = (class_2350)state.method_11654((class_2769)CreativeMotorBlock.FACING);
            if (facing.method_10166() != class_2350.class_2351.field_11052 && direction == class_2350.field_11033) {
                return false;
            }
            return direction.method_10166() != facing.method_10166();
        }
    }
}

